/*
 * Decompiled with CFR 0.152.
 */
package com.yollo.dmlreforged.core.container;

import com.yollo.dmlreforged.common.blocks.entity.BlockEntitySimulationChamber;
import com.yollo.dmlreforged.common.items.ItemLivingMatter;
import com.yollo.dmlreforged.common.items.ItemPristineMatter;
import com.yollo.dmlreforged.core.container.slots.SlotSimulationChamber;
import com.yollo.dmlreforged.core.container.sync.SimulationChamberContainerData;
import com.yollo.dmlreforged.core.init.BlockInit;
import com.yollo.dmlreforged.core.init.ContainerInit;
import com.yollo.dmlreforged.core.util.DataModelHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SimulationChamberContainer
extends AbstractContainerMenu {
    public static final int DATA_MODEL_SLOT = 0;
    public static final int POLYMER_SLOT = 1;
    public static final int LIVING_SLOT = 2;
    public static final int PRISTINE_SLOT = 3;
    private final ContainerLevelAccess containerAccess;
    public final ContainerData data;
    public IItemHandler handler;

    public SimulationChamberContainer(int id, Inventory playerInv) {
        this(id, playerInv, (IItemHandler)new ItemStackHandler(4), BlockPos.f_121853_, (ContainerData)new SimpleContainerData(4));
    }

    public SimulationChamberContainer(int pContainerId, Inventory pInventory, IItemHandler handler, BlockPos pPos, ContainerData data) {
        super((MenuType)ContainerInit.SIMULATION_CHAMBER.get(), pContainerId);
        this.handler = handler;
        this.containerAccess = ContainerLevelAccess.m_39289_((Level)pInventory.f_35978_.f_19853_, (BlockPos)pPos);
        this.data = data;
        this.addInventorySlots(pInventory);
        this.addSlotsToHandler(handler);
        this.m_38884_(data);
    }

    private void addInventorySlots(Inventory playerInv) {
        int row;
        for (row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int x = 8 + column * 18;
                int y = 119 + row * 18;
                int index = column + row * 9 + 9;
                Slot slot = new Slot((Container)playerInv, index, x, y);
                this.m_38897_(slot);
            }
        }
        for (row = 0; row < 9; ++row) {
            Slot slot = new Slot((Container)playerInv, row, 8 + row * 18, 177);
            this.m_38897_(slot);
        }
    }

    private void addSlotsToHandler(IItemHandler handler) {
        this.m_38897_((Slot)new SlotSimulationChamber(handler, 0, -40, -35));
        this.m_38897_((Slot)new SlotSimulationChamber(handler, 1, 148, -29));
        this.m_38897_((Slot)new SlotSimulationChamber(handler, 2, 168, -29));
        this.m_38897_((Slot)new SlotSimulationChamber(handler, 3, 158, -9));
    }

    public boolean m_6875_(Player pPlayer) {
        return SimulationChamberContainer.m_38889_((ContainerLevelAccess)this.containerAccess, (Player)pPlayer, (Block)((Block)BlockInit.SIMULATION_CHAMBER.get()));
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack retStack = ItemStack.f_41583_;
        Slot slot = this.m_38853_(index);
        if (slot.m_6657_()) {
            ItemStack item = slot.m_7993_();
            retStack = item.m_41777_();
            if (index < 36 ? !this.m_38903_(item, 36, this.f_38839_.size(), true) : !this.m_38903_(item, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (item.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return retStack;
    }

    public static MenuConstructor getServerContainer(BlockEntitySimulationChamber be, BlockPos pos) {
        return (id, playerInv, player) -> new SimulationChamberContainer(id, playerInv, (IItemHandler)be.inventory, pos, (ContainerData)new SimulationChamberContainerData(be, 4));
    }

    public ItemStack getDataModel() {
        return this.handler.getStackInSlot(0);
    }

    public ItemStack getPolymerClay() {
        return this.handler.getStackInSlot(1);
    }

    private static boolean dataModelMatchesOutput(ItemStack stack, ItemStack output) {
        ItemLivingMatter livingMatter = DataModelHelper.getMobMetaData(stack).getLivingMatter();
        return ((Object)((Object)livingMatter)).getClass().equals(output.m_41720_().getClass());
    }

    private static boolean dataModelMatchesPristine(ItemStack stack, ItemStack pristine) {
        ItemPristineMatter pristineMatter = DataModelHelper.getMobMetaData(stack).getPristineMatter();
        return ((Object)((Object)pristineMatter)).getClass().equals(pristine.m_41720_().getClass());
    }

    public boolean outputIsFull() {
        ItemStack stack = this.handler.getStackInSlot(2);
        if (stack.m_41619_()) {
            return false;
        }
        boolean stackLimitReached = stack.m_41613_() == this.handler.getSlotLimit(2);
        boolean outputMatches = SimulationChamberContainer.dataModelMatchesOutput(this.getDataModel(), this.handler.getStackInSlot(2));
        return stackLimitReached || !outputMatches;
    }

    public boolean pristineIsFull() {
        ItemStack stack = this.handler.getStackInSlot(3);
        if (stack.m_41619_()) {
            return false;
        }
        boolean stackLimitReached = stack.m_41613_() == this.handler.getSlotLimit(3);
        boolean outputMatches = SimulationChamberContainer.dataModelMatchesPristine(this.getDataModel(), this.handler.getStackInSlot(3));
        return stackLimitReached || !outputMatches;
    }
}

